/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.util;

import com.github.L_Ender.cataclysm.entity.BossMonster.The_Leviathan.The_Leviathan_Tongue_Entity;
import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LeviathanTongueUtil {
    private static final String LAST_TONGUE_UUID = "LastTongueUUIDCataclysm";
    private static final String LAST_TONGUE_ID = "LastTongueIDCataclysm";

    private static void sync(LivingEntity enchanted, CompoundTag tag) {
        CitadelEntityData.setCitadelTag((LivingEntity)enchanted, (CompoundTag)tag);
        if (!enchanted.f_19853_.f_46443_) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CataclysmTagUpdate", tag, enchanted.m_19879_()));
        } else {
            Citadel.sendMSGToServer((Object)new PropertiesMessage("CataclysmTagUpdate", tag, enchanted.m_19879_()));
        }
    }

    public static void setLastTongue(LivingEntity entity, The_Leviathan_Tongue_Entity tendon) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tendon == null) {
            tag.m_128473_(LAST_TONGUE_UUID);
            tag.m_128405_(LAST_TONGUE_ID, -1);
        } else {
            tag.m_128362_(LAST_TONGUE_UUID, tendon.m_20148_());
            tag.m_128405_(LAST_TONGUE_ID, tendon.m_19879_());
        }
        LeviathanTongueUtil.sync(entity, tag);
    }

    private static UUID getLastTongueUUID(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.m_128441_(LAST_TONGUE_UUID)) {
            return tag.m_128342_(LAST_TONGUE_UUID);
        }
        return null;
    }

    public static int getLastTongueId(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.m_128441_(LAST_TONGUE_ID)) {
            return tag.m_128451_(LAST_TONGUE_ID);
        }
        return -1;
    }

    public static void retractFarTongues(Level level, LivingEntity livingEntity) {
        The_Leviathan_Tongue_Entity last = LeviathanTongueUtil.getLastTendon(livingEntity);
        if (last != null) {
            last.m_142687_(Entity.RemovalReason.DISCARDED);
            LeviathanTongueUtil.setLastTongue(livingEntity, null);
        }
    }

    public static boolean canLaunchTongues(Level level, LivingEntity livingEntity) {
        The_Leviathan_Tongue_Entity last = LeviathanTongueUtil.getLastTendon(livingEntity);
        if (last != null) {
            return last.m_213877_();
        }
        return true;
    }

    public static The_Leviathan_Tongue_Entity getLastTendon(LivingEntity livingEntity) {
        UUID uuid = LeviathanTongueUtil.getLastTongueUUID(livingEntity);
        int id = LeviathanTongueUtil.getLastTongueId(livingEntity);
        if (!livingEntity.f_19853_.f_46443_) {
            if (uuid != null) {
                Entity e = livingEntity.f_19853_.m_6815_(id);
                return e instanceof The_Leviathan_Tongue_Entity ? (The_Leviathan_Tongue_Entity)e : null;
            }
        } else if (id != -1) {
            Entity e = livingEntity.f_19853_.m_6815_(id);
            return e instanceof The_Leviathan_Tongue_Entity ? (The_Leviathan_Tongue_Entity)e : null;
        }
        return null;
    }
}

